#!/usr/bin/env python3
# coding: utf-8
##############################################################################
#
# @brief Spec file that used to collect all data files for corresponding package
# All other configuration options will be taken from pyproject.toml
#
# @author dmitry.ryzhov@cloudbear.ru
#
# Copyright (c) 2025 CloudBEAR LLC, all rights reserved.
#
# This file contains confidential, proprietary information and trade
# secrets of CloudBEAR LLC. The information contained in this file
# may only be used by a person authorised under and to the extent
# permitted by a subsisting license agreement or design service
# agreement from CloudBEAR LLC.
#
# This entire notice must be reproduced on all copies of this file
# and copies of this file may only be made by a person if such person
# is permitted to do so under the terms of a subsisting license
# agreement or design service agreement from CloudBEAR LLC.
#
##############################################################################

import collections
import glob
import os
import setuptools
import tomllib

with open('pyproject.toml', 'rb') as f:
    config = tomllib.load(f)
package_name = config['project']['name']
data_target_dir = config.get('tool', {}).get('bear-pipbuildkit', {}).get(
    'data-target-dir', package_name)
data_patterns = config.get('tool', {}).get('bear-pipbuildkit', {}).get('data-patterns', [])
scripts_patterns = config.get('tool', {}).get('bear-pipbuildkit', {}).get('scripts-patterns', [])


def get_data_files(target_dir, patterns):
    data_files_dict = collections.defaultdict(list)
    for pattern in patterns:
        matching_files = glob.glob(pattern, recursive=True)
        if not matching_files:
            print(f'Warning: No matches found for pattern "{pattern}"')
        for filepath in matching_files:
            if os.path.isfile(filepath):
                rel_path = os.path.relpath(filepath, '.')
                install_dir = os.path.dirname(rel_path)
                if target_dir:
                    install_dir = os.path.join(target_dir, install_dir)
                data_files_dict[install_dir].append(filepath)
            else:
                print(f'Warning: {filepath} is not a file and will be skipped.')

    data_files = list(data_files_dict.items())
    return data_files


def get_scripts(patterns):
    scripts = []
    for pattern in patterns:
        scripts.extend(glob.glob(pattern))

    return scripts


setuptools.setup(
    data_files=get_data_files(data_target_dir, data_patterns),
    scripts=get_scripts(scripts_patterns),
)
