#!/usr/bin/env python3
# coding: utf-8
##############################################################################
#
# @brief Script for making bear-platform source and binary packages
#
# @author andrey.efimov@cloudbear.ru
#
# Copyright (c) 2025 CloudBEAR LLC, all rights reserved.
#
# This file contains confidential, proprietary information and trade
# secrets of CloudBEAR LLC. The information contained in this file
# may only be used by a person authorised under and to the extent
# permitted by a subsisting license agreement or design service
# agreement from CloudBEAR LLC.
#
# This entire notice must be reproduced on all copies of this file
# and copies of this file may only be made by a person if such person
# is permitted to do so under the terms of a subsisting license
# agreement or design service agreement from CloudBEAR LLC.
#
##############################################################################

import pathlib
import os
import setuptools

package_name = 'bear-platform'
package_version = '1.2.10'

data_files = []
for root, dirs, files in os.walk(package_name):
    data_files.append((root, [os.path.join(root, f) for f in files]))

setuptools.setup(
    name=package_name,
    version=package_version,
    url='https://cloudbear.ru',
    author='Denis Ivanov',
    author_email='denis.ivanov@cloudbear.ru',
    description='Tools for running tests on FPGA designs',
    classifiers=[
        'Private :: Do Not Upload',
        'Programming Language :: C++',
        'Topic :: System :: Hardware',
        'Operating System :: POSIX :: Linux',
    ],
    license='LicenseRef-CloudBEAR-License',
    data_files=data_files,
    package_dir={'': '.'}  # Forces *.egg-info to be located in root dir instead of src subdir
)
