# Package Overview for RISC-V OpenOCD

## About RISC-V OpenOCD

Fork of OpenOCD that has RISC-V support.

OpenOCD provides on-chip programming and debugging support with a
layered architecture of JTAG interface and TAP support including:
    * (X)SVF playback to facilitate automated boundary scan and FPGA/CPLD  programming;
    * debug target support (e.g. ARM, MIPS): single-stepping, breakpoints/watchpoints,
        gprof profiling, etc;
    * flash chip drivers (e.g. CFI, NAND, internal flash);
    * embedded TCL interpreter for easy scripting.

CloudBEAR version contains modifications (mostly configs and small fixes) for usage
of OpenOCD with CloudBEAR coreplexes.

## Upstream

[RISC-V OpenOCD](https://github.com/riscv-collab/riscv-openocd)

## Version History

* Version 0.12.0.1, 17 Jul 2025
    * Add config (bear-generic.cfg) for CB coreplexes
    * Add config (bear-trace.cfg) for Nexus Trace support
    * Add dummy CB flash driver (bear_direct)
    * Configuration files for packaging in CloudBEAR infrustructure
